﻿using System;
using System.IO;
using System.Linq;
using System.Net;
using System.Xml.Linq;

namespace HttpXmlLinq
{
    class Program
    {
        static void Main(string[] args)
        {
            // Listing 13-12. Pobieranie danych z protokołu HTTP do LINQ to XML za pośrednictwem klasy Stream
            WebClient client = new WebClient();
            Stream feedStm = client.OpenRead("http://feeds.feedburner.com/oreilly/news");
            XDocument feedXml = XDocument.Load(feedStm);

            string ns = "http://www.w3.org/2005/Atom";
            var entries = from entryElement in feedXml.Descendants(XName.Get("entry", ns))
                          select new
                          {
                              Title = entryElement.Element(XName.Get("title", ns)).Value,
                              Link = entryElement.Element(XName.Get("link", ns)).
                                Attribute("href").Value
                          };
            foreach (var entry in entries)
            {
                Console.WriteLine("{0}: {1}", entry.Title, entry.Link);
            }
        }
    }
}